/*
 * Decompiled with CFR 0.152.
 */
package mcjty.incontrol.compat;

import java.util.function.Function;
import mcjty.incontrol.InControl;
import mcjty.lostcities.api.ILostChunkInfo;
import mcjty.lostcities.api.ILostCities;
import mcjty.lostcities.api.ILostCityInformation;
import mcjty.tools.rules.IEventQuery;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.ModList;

public class LostCitySupport {
    private static boolean registered = false;
    private static ILostCities lostCities;

    public static void register() {
        if (ModList.get().isLoaded("lostcities")) {
            LostCitySupport.registerInternal();
        }
    }

    private static void registerInternal() {
        if (registered) {
            return;
        }
        registered = true;
        InterModComms.sendTo((String)"lostcities", (String)"getLostCities", GetLostCities::new);
        InControl.setup.getLogger().info("Enabling support for Lost Cities");
    }

    private static <T> World getWorld(IEventQuery<T> query, T event) {
        World w;
        IWorld world = query.getWorld(event);
        if (world.func_201670_d()) {
            return null;
        }
        if (world instanceof World) {
            w = (World)world;
        } else if (world instanceof IServerWorld) {
            w = ((IServerWorld)world).func_201672_e();
        } else {
            throw new IllegalStateException("Bad world!");
        }
        return w;
    }

    public static <T> boolean isCity(IEventQuery<T> query, T event) {
        World w = LostCitySupport.getWorld(query, event);
        if (w == null) {
            return false;
        }
        ILostCityInformation info = lostCities.getLostInfo(w);
        if (info != null) {
            BlockPos pos = query.getPos(event);
            ILostChunkInfo chunkInfo = info.getChunkInfo(pos.func_177958_n() >> 4, pos.func_177952_p() >> 4);
            return chunkInfo.isCity();
        }
        return false;
    }

    public static <T> boolean isStreet(IEventQuery<T> query, T event) {
        World w = LostCitySupport.getWorld(query, event);
        if (w == null) {
            return false;
        }
        ILostCityInformation info = lostCities.getLostInfo(w);
        if (info != null) {
            BlockPos pos = query.getPos(event);
            ILostChunkInfo chunkInfo = info.getChunkInfo(pos.func_177958_n() >> 4, pos.func_177952_p() >> 4);
            return chunkInfo.isCity() && chunkInfo.getBuildingType() == null;
        }
        return false;
    }

    public static <T> boolean inSphere(IEventQuery<T> query, T event) {
        World w = LostCitySupport.getWorld(query, event);
        if (w == null) {
            return false;
        }
        ILostCityInformation info = lostCities.getLostInfo(w);
        if (info != null) {
            BlockPos pos = query.getPos(event);
            ILostChunkInfo chunkInfo = info.getChunkInfo(pos.func_177958_n() >> 4, pos.func_177952_p() >> 4);
            return chunkInfo.getSphere() != null;
        }
        return false;
    }

    public static <T> boolean isBuilding(IEventQuery<T> query, T event) {
        World w = LostCitySupport.getWorld(query, event);
        if (w == null) {
            return false;
        }
        ILostCityInformation info = lostCities.getLostInfo(w);
        if (info != null) {
            BlockPos pos = query.getPos(event);
            ILostChunkInfo chunkInfo = info.getChunkInfo(pos.func_177958_n() >> 4, pos.func_177952_p() >> 4);
            return chunkInfo.isCity() && chunkInfo.getBuildingType() != null;
        }
        return false;
    }

    public static class GetLostCities
    implements Function<ILostCities, Void> {
        @Override
        public Void apply(ILostCities lc) {
            lostCities = lc;
            return null;
        }
    }
}

